package gov.va.med.mhv.common.data.converter;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.AddressDTO;
import gov.va.med.mhv.common.api.dto.ContactDTO;
import gov.va.med.mhv.common.api.dto.NameDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDeactivationReasonDTO;
import gov.va.med.mhv.common.data.model.AccessRole;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;
import gov.va.med.mhv.common.data.util.SsnFormatter;

@Component
public class UserProfileConverter {

	private static final Log LOG = LogFactory.getLog(UserProfileConverter.class);

	private static final String DF_IMPRECISE_BIRTH_DATE = "YYYYMMdd'.120000'";

	@Autowired
	private UserProfileDeactivationReasonConverter userProfileDeactivationReasonConverter;

	/**
	 * Converts Domain  object to DTO that is used on html page
	 */
	public UserProfileDTO  convertDomainUserProfile( UserProfile profile ){
		UserProfileDTO userDto = new UserProfileDTO();
		userDto.setId(profile.getId());
		userDto.setAddress(getAddress(profile));
		userDto.setContact(getContact(profile));
		userDto.setName(getName(profile));
		userDto.setAccessRoles(getRoles(profile));
		userDto.setPasswordHintQuestion1(profile.getPasswordHintQuestion1());
		userDto.setPasswordHintQuestion2(profile.getPasswordHintQuestion2());
		userDto.setOccupation(profile.getCurrentOccupation());
		userDto.setAcceptDisclaimer(profile.getAcceptDisclaimer());
		userDto.setAcceptPrivacy(profile.getAcceptPrivacy());
		userDto.setAcceptSMTerms(profile.getAcceptSMTerms());
		userDto.setAcceptTerms(profile.getAcceptTerms());
		userDto.setPasswordHintAnswer1(profile.getPasswordHintAnswer1());
		userDto.setPasswordHintAnswer2(profile.getPasswordHintAnswer2());
		userDto.setAutoAuth(profile.getAutoAuth());
		userDto.setAutoAuthDate(profile.getAutoAuthDate());
		userDto.setBirthDate(profile.getBirthDate());
		userDto.setBloodType(profile.getBloodType());
		userDto.setConfirmationLockOut(profile.getConfirmationLockOut());
		userDto.setCreatedDate(profile.getCreatedDate());
		userDto.setEhrAccess(profile.getEhrAccess());
		userDto.setEmailCredentials(profile.getEmailCredentials());
		userDto.setEmailHealthAwareness(profile.getEmailHealthAwareness());
		userDto.setGender(profile.getGender());
		userDto.setInterestAlcohol(profile.getInterestAlcohol());
		userDto.setInterestBloodPressure(profile.getInterestBloodPressure());
		userDto.setInterestDepression(profile.getInterestDepression());
		userDto.setInterestDiabetes(profile.getInterestDiabetes());
		userDto.setInterestDiet(profile.getInterestDiet());
		userDto.setInterestExercise(profile.getInterestExercise());
		userDto.setInterestHeart(profile.getInterestHeart());
		userDto.setInterestMilitaryRelated(profile.getInterestMilitaryRelated());
		userDto.setInterestPTSD(profile.getInterestPTSD());
		userDto.setInterestReminder(profile.getInterestReminder());
		userDto.setInterestSmoking(profile.getInterestSmoking());
		userDto.setInterestStress(profile.getInterestStress());
		userDto.setMaritalStatus(profile.getMaritalStatus());
		userDto.setMhvId(profile.getMhvId());
		userDto.setIsMPIControlled(profile.getIsMPIControlled());
		userDto.setOrganDonor(profile.getIsOrganDonor());
		userDto.setOrientationVideoView(profile.getOrientationVideoView());
		userDto.setParticipationFormSign(profile.getParticipationFormSign());

		userDto.setIsPatient(profile.getIsPatient());
		userDto.setIsPatientAdvocate(profile.getIsPatientAdvocate());
		userDto.setIsVeteran(profile.getIsVeteran());
		userDto.setIsEmployee(profile.getIsEmployee());
		userDto.setIsHealthCareProvider(profile.getIsHealthCareProvider());
		userDto.setIsChampVABeneficiary(profile.getIsChampVABeneficiary());
		userDto.setIsServiceMember(profile.getIsServiceMember());
		userDto.setIsOther(profile.getIsOther());

		userDto.setPhysicalProof(profile.getPhysicalProof());
		userDto.setProofInstitutionId(profile.getProofInstitutionId());
		userDto.setProofLevel(profile.getProofLevel());
		userDto.setProofLevelDate(profile.getProofLevelDate());
		userDto.setRxAgreementDate(profile.getRxAgreementDate());
		userDto.setRxAgreementSigned(profile.getRxAgreementSigned());
		userDto.setSsn(profile.getSsn());
		userDto.setConfSsn(profile.getSsn());
		userDto.setUserName(profile.getUserName());

		userDto.setOplock(profile.getOplock());

		userDto.setDeathDate(profile.getDeathDate());
		userDto.setRxTrackingEmailPref(profile.getRxTrackingEmailPref());
		userDto.setApptReminderEmailPref(profile.getApptReminderEmailPref());
		userDto.setHealthSummarySentEmailPref(profile.getHealthSummarySentEmailPref());
		userDto.setBbmiEmailPref(profile.getBbmiEmailPref());
		userDto.setModifiedDate(profile.getModifiedDate());
		userDto.setFccx(profile.getFccx());
		userDto.setCurrentLogin(profile.getCurrentLogin());
		userDto.setImpreciseBirthDate((profile.getImpreciseBirthDate() == null &&
				                       profile.getBirthDate() != null) ?
				                    		   new SimpleDateFormat(DF_IMPRECISE_BIRTH_DATE).format(profile.getBirthDate()) : profile.getImpreciseBirthDate());
		userDto.setLastLogin(profile.getLastLogin());

		userDto.setRestrictSIPAccess(profile.getRestrictSIPAccess());
		userDto.setRestrictSIPAccessBy(profile.getRestrictSIPAccessBy());
		userDto.setRestrictSIPAccessDate(profile.getRestrictSIPAccessDate());
		userDto.setRestrictSIPAccessReason(profile.getRestrictSIPAccessReason());

		userDto.setAccountDeactivationWarning(profile.getAccountDeactivationWarning());
		userDto.setDeactivationAdmin(profile.getDeactivationAdmin());
		userDto.setDeactivationCode(profile.getDeactivationCode());
		userDto.setDeactivationDateTime(profile.getDeactivationDateTime());
		userDto.setDeactivationDescriptionText(profile.getDeactivationDescriptionText());
		if(profile.getDeactivationReason() != null ) {
			userDto.setDeactivationReason(userProfileDeactivationReasonConverter.convert
					(profile.getDeactivationReason()));
		} 
		if(profile.getDeactivationReason() ==  null) {
			if (profile.getDeactivationCode() != null) {
				if(profile.getDeactivationCode() == 14) {
					UserProfileDeactivationReasonDTO reasonDTO = new UserProfileDeactivationReasonDTO();
					reasonDTO.setId(profile.getDeactivationCode());
					reasonDTO.setName("Inactive Account");
					reasonDTO.setOplock(1);
					userDto.setDeactivationReason(reasonDTO);
				}
			}
		}
		

		return userDto ;
	}

	private AddressDTO getAddress(UserProfile user){
		AddressDTO add = new AddressDTO();
		add.setAddress1(user.getAddressStreet1());
		add.setAddress2(user.getAddressStreet2());
		add.setCity(user.getAddressCity());
		add.setState(user.getAddressState());
		add.setProvince(user.getAddressProvince());
		add.setCountry(user.getAddressCountry());
		add.setZip(user.getAddressPostalCode());
		return add;
	}

	private ContactDTO getContact(UserProfile user) {
		ContactDTO con = new ContactDTO();
		con.setContactMethod(user.getContactInfoContactMethod());
		con.setEmail(user.getContactInfoEmail());
		con.setFax(user.getContactInfoFax());
		con.setHomePhone(user.getContactInfoHomePhone());
		con.setMobilePhone(user.getContactInfoMobilePhone());
		con.setPager(user.getContactInfoPager());
		con.setWorkPhone(user.getContactInfoWorkPhone());
		return con;
	}

	private NameDTO getName(UserProfile user) {
		NameDTO n = new NameDTO();
		n.setAlias(user.getUserAlias());
		n.setFirstName(user.getFirstName());
		n.setLastName(user.getLastName());
		n.setMiddleName(user.getMiddleName());
		n.setSuffix(user.getSuffix());
		n.setTitle(user.getTitle());
		return n;
	}

	private List<String> getRoles(UserProfile user) {
		List<String> roles = new ArrayList<String>();
		if (null != user.getAccessRoles()) {
			for (AccessRole role : user.getAccessRoles()) {
				roles.add(role.getName());
			}
		}
		return roles;
	}

	/**
	 * Converts DTO from web page to Domain Object -> persist into user_profile
	 * table
	 */
	public UserProfile convertDTOProfile(UserProfile domainProfile, UserProfileDTO userDto) {
		userDto.setSsn(SsnFormatter.format(userDto.getSsn()));
		this.generateMhvId(userDto);

		if (null != userDto.getAddress()) {
			domainProfile.setAddressStreet1(userDto.getAddress().getAddress1());
			domainProfile.setAddressStreet2(userDto.getAddress().getAddress2());
			domainProfile.setAddressCity(userDto.getAddress().getCity());
			domainProfile.setAddressState(userDto.getAddress().getState());
			domainProfile.setAddressProvince(userDto.getAddress().getProvince());
			domainProfile.setAddressCountry(userDto.getAddress().getCountry());
			domainProfile.setAddressPostalCode(userDto.getAddress().getZip());
		}
		if (null != userDto.getContact()) {
			domainProfile.setContactInfoContactMethod(userDto.getContact().getContactMethod());
			domainProfile.setContactInfoEmail(userDto.getContact().getEmail());
			domainProfile.setContactInfoFax(userDto.getContact().getFax());
			domainProfile.setContactInfoHomePhone(userDto.getContact().getHomePhone());
			domainProfile.setContactInfoMobilePhone(userDto.getContact().getMobilePhone());
			domainProfile.setContactInfoPager(userDto.getContact().getPager());
			domainProfile.setContactInfoWorkPhone(userDto.getContact().getWorkPhone());
		}

		domainProfile.setFirstName(userDto.getName().getFirstName());
		domainProfile.setLastName(userDto.getName().getLastName());
		domainProfile.setMiddleName(userDto.getName().getMiddleName());
		domainProfile.setUserAlias(userDto.getName().getAlias());
		domainProfile.setSuffix(userDto.getName().getSuffix());
		domainProfile.setTitle(userDto.getName().getTitle());
		domainProfile.setPasswordHintQuestion1(userDto.getPasswordHintQuestion1());
		domainProfile.setPasswordHintQuestion2(userDto.getPasswordHintQuestion2());

		domainProfile.setId(userDto.getId());
		domainProfile.setCurrentOccupation(userDto.getOccupation());
		domainProfile.setAcceptDisclaimer(userDto.getAcceptDisclaimer());
		domainProfile.setAcceptPrivacy(userDto.getAcceptPrivacy());
		domainProfile.setAcceptSMTerms(userDto.getAcceptSMTerms());
		domainProfile.setAcceptTerms(userDto.getAcceptTerms());
		domainProfile.setPasswordHintAnswer1(userDto.getPasswordHintAnswer1());
		domainProfile.setPasswordHintAnswer2(userDto.getPasswordHintAnswer2());
		domainProfile.setAutoAuth(userDto.getAutoAuth());
		domainProfile.setAutoAuthDate(userDto.getAutoAuthDate());
		domainProfile.setBirthDate(userDto.getBirthDate());
		domainProfile.setBloodType(userDto.getBloodType());
		domainProfile.setConfirmationLockOut(userDto.getConfirmationLockOut());
		domainProfile.setCreatedDate(userDto.getCreatedDate());
		domainProfile.setEhrAccess(userDto.getEhrAccess());
		domainProfile.setEmailCredentials(userDto.getEmailCredentials());
		domainProfile.setEmailHealthAwareness(userDto.getEmailHealthAwareness());

		domainProfile.setGender(userDto.getGender());

		domainProfile.setInterestAlcohol(userDto.getInterestAlcohol());
		domainProfile.setInterestBloodPressure(userDto.getInterestBloodPressure());
		domainProfile.setInterestDepression(userDto.getInterestDepression());
		domainProfile.setInterestDiabetes(userDto.getInterestDiabetes());
		domainProfile.setInterestDiet(userDto.getInterestDiet());
		domainProfile.setInterestExercise(userDto.getInterestExercise());
		domainProfile.setInterestHeart(userDto.getInterestHeart());
		domainProfile.setInterestMilitaryRelated(userDto.getInterestMilitaryRelated());
		domainProfile.setInterestPTSD(userDto.getInterestPTSD());
		domainProfile.setInterestReminder(userDto.getInterestReminder());
		domainProfile.setInterestSmoking(userDto.getInterestSmoking());
		domainProfile.setInterestStress(userDto.getInterestStress());
		domainProfile.setMaritalStatus(userDto.getMaritalStatus());
		domainProfile.setMhvId(userDto.getMhvId());
		domainProfile.setIsMPIControlled(userDto.getIsMPIControlled());
		domainProfile.setIsOrganDonor(userDto.getOrganDonor());

		domainProfile.setOrientationVideoView(userDto.getOrientationVideoView());
		domainProfile.setParticipationFormSign(userDto.getParticipationFormSign());

		domainProfile.setIsPatient(userDto.getIsPatient());
		domainProfile.setIsPatientAdvocate(userDto.getIsPatientAdvocate());
		domainProfile.setIsVeteran(userDto.getIsVeteran());
		domainProfile.setIsEmployee(userDto.getIsEmployee());
		domainProfile.setIsHealthCareProvider(userDto.getIsHealthCareProvider());
		domainProfile.setIsChampVABeneficiary(userDto.getIsChampVABeneficiary());
		domainProfile.setIsServiceMember(userDto.getIsServiceMember());
		domainProfile.setIsOther(userDto.getIsOther());

		domainProfile.setPhysicalProof(userDto.getPhysicalProof());
		domainProfile.setProofInstitutionId(userDto.getProofInstitutionId());
		domainProfile.setProofLevel(userDto.getProofLevel());
		domainProfile.setProofLevelDate(userDto.getProofLevelDate());
		domainProfile.setRxAgreementDate(userDto.getRxAgreementDate());
		domainProfile.setRxAgreementSigned(userDto.getRxAgreementSigned());
		domainProfile.setSsn(userDto.getSsn());
		domainProfile.setUserName(userDto.getUserName());

		domainProfile.setOplock(userDto.getOplock());

		// domainProfile.setDeathDate(profile.getDeathDate());
		domainProfile.setRxTrackingEmailPref(userDto.getRxTrackingEmailPref());
		domainProfile.setApptReminderEmailPref(userDto.getApptReminderEmailPref());
		domainProfile.setBbmiEmailPref(userDto.getBbmiEmailPref());
		domainProfile.setHealthSummarySentEmailPref(userDto.getHealthSummarySentEmailPref());
		domainProfile.setModifiedDate(userDto.getModifiedDate());
		// userProfile.setFccx(profile.getFccx());
		domainProfile.setCurrentLogin(userDto.getCurrentLogin());
		domainProfile.setLastLogin(userDto.getLastLogin());
		domainProfile.setImpreciseBirthDate(userDto.getImpreciseBirthDate() == null && userDto.getBirthDate() != null ?
				new SimpleDateFormat(DF_IMPRECISE_BIRTH_DATE).format(userDto.getBirthDate()) : userDto.getImpreciseBirthDate());

		domainProfile.setSignInPartners(userDto.getSignInPartners());
		domainProfile.setRestrictSIPAccess(userDto.getRestrictSIPAccess());
		domainProfile.setRestrictSIPAccessBy(userDto.getRestrictSIPAccessBy());
		domainProfile.setRestrictSIPAccessReason(userDto.getRestrictSIPAccessReason());
		domainProfile.setRestrictSIPAccesssDate(userDto.getRestrictSIPAccessDate());
		domainProfile.setAccountDeactivationWarning(userDto.getAccountDeactivationWarning());
		domainProfile.setDeactivationAdmin(userDto.getDeactivationAdmin());
		domainProfile.setDeactivationCode(userDto.getDeactivationCode());
		domainProfile.setDeactivationDateTime(userDto.getDeactivationDateTime());
		domainProfile.setDeactivationDescriptionText(userDto.getDeactivationDescriptionText());
		domainProfile.setIsAlternate(userDto.getIsAlternate());
		if(userDto.getDeactivationReason() != null ) {
			UserProfileDeactivationReason reason = new UserProfileDeactivationReason();
			reason.setId(userDto.getDeactivationReason().getId());
			reason.setName(userDto.getDeactivationReason().getName());
			reason.setOplock(userDto.getDeactivationReason().getOplock());
			domainProfile.setDeactivationReason(reason);
		} 
		if(userDto.getDeactivationReason() ==  null) {
			if (userDto.getDeactivationCode() != null) {
				if(userDto.getDeactivationCode() == 14) {
					UserProfileDeactivationReason reason = new UserProfileDeactivationReason();
					reason.setId(userDto.getDeactivationCode());
					reason.setName("Inactive Account");
					reason.setOplock(1);
					domainProfile.setDeactivationReason(reason);
				}
			}
		}
		return domainProfile;
	}

	/**
	 * Only generate MhvId on an insert. This method is pulled from MHV Core.
	 *
	 * @param userProfileDto
	 */
	private void generateMhvId(UserProfileDTO userProfileDto) {
		if (StringUtils.isNotBlank(userProfileDto.getMhvId())) {
			// Only generate on an insert.
			return;
		}

		String firstInitial = StringUtils.upperCase(userProfileDto.getName().getFirstName().substring(0, 1));
		String lastInitial = StringUtils.upperCase(userProfileDto.getName().getLastName().substring(0, 1));

		StringBuffer mhvId = new StringBuffer("M");
		mhvId.append(firstInitial);
		mhvId.append(lastInitial);
		mhvId.append(userProfileDto.getGender().charAt(0));
		mhvId.append('-');

		Calendar calendar = Calendar.getInstance();
		calendar.setTime(userProfileDto.getBirthDate());
		String bdYear = String.valueOf(calendar.get(Calendar.YEAR));
		mhvId.append(bdYear.substring(2));
		mhvId.append('-');
		mhvId.append(getRandomFourDigit());

		userProfileDto.setMhvId(mhvId.toString());
	}

	/**
	 * Only generate MhvId on an insert. This method is pulled from MHV Core.
	 *
	 * @param userProfileDto
	 */
	public void generateMhvId(UserProfile userProfile) {
		if (StringUtils.isNotBlank(userProfile.getMhvId())) {
			// Only generate on an insert.
			return;
		}

		String firstInitial = StringUtils.upperCase(userProfile.getFirstName().substring(0, 1));
		String lastInitial = StringUtils.upperCase(userProfile.getLastName().substring(0, 1));

		StringBuffer mhvId = new StringBuffer("M");
		mhvId.append(firstInitial);
		mhvId.append(lastInitial);
		mhvId.append(userProfile.getGender().charAt(0));
		mhvId.append('-');

		Calendar calendar = Calendar.getInstance();
		calendar.setTime(userProfile.getBirthDate());
		String bdYear = String.valueOf(calendar.get(Calendar.YEAR));
		mhvId.append(bdYear.substring(2));
		mhvId.append('-');
		mhvId.append(getRandomFourDigit());

		userProfile.setMhvId(mhvId.toString());
	}
	
	/**
	 * Generates a random integral number
	 *
	 * @return int The value of the randomly generated number.
	 */
	String getRandomFourDigit() {
		try {
			int num = SecureRandom.getInstance("SHA1PRNG").nextInt(9999);

			// pad the number
			String random = String.valueOf(num);
			StringBuffer buff = new StringBuffer();
			for(int i = random.length(); i < 4; i++) {
				// prepend the random number with zeros if it's not 4 in length
				buff.append("0");
			}

			buff.append(random);

			return buff.toString();
		} catch (NoSuchAlgorithmException nsaex) {
			LOG.error("Error getting random digit.");
			throw new IllegalArgumentException(nsaex);
		}
	}
}
